/**
 * 
 */
package gov.va.genisis2.common.enums;

/**
 * The Enum CommonEnum.
 *
 * @author Getaneh Kassahun
 */

public enum CommonEnum {

	/** The no record found. */
	NO_RECORD_FOUND("No records found."),

	/** The space. */
	SPACE(" "),

	/** The unable to create request. */
	UNABLE_TO_CREATE_REQUEST("Unable to create Request. Business process failed to start."),

	/** The unable to update study approval. */
	UNABLE_TO_UPDATE_STUDY_APPROVAL("Unable to update Study Approval"),

	/** The created By. */
	REQUEST_CREATED_BY("createdBy"),

	/** The status description */
	STATUS_DESC("statusDescription"),
	
	/** The status id */
	STATUS_ID("id"),
	
	/** The Workflow status description */
	STATUS_WORKFLOW_DESC("description"),

	

	/** The users */
	USER("user"),
	
	/** The user Id */
	ID_COLUMN("id"),

	/** The user Id */
	USER_ID("userId"),
	
	/** The user name */
	USER_NAME("username"),
	
	/** The email Id */
	EMAIL_ID("emailId"),
	
	/** The user status */
	USER_ACTIVE("userActive"),
	
	/** The role type id */
	ROLE_TYPE_ID("roleTypeId"),
	
	USER_ROLE_TYPES("userRoleTypes"),
	
	/** The end date */
	END_DATE("endDate"),
	
	/** The Status */
	STATUS("status"),
	
	/** The Status Completed */
	STATUS_COMPLETED("Completed"),

	/** The user Id */
	NO_RESULT_ENTITY("No Result Exception. User Id: "),

	/** The user Id */
	NO_RESULT_EXCEPTION("NoResultException"),
	
	VERSION("version"),

	/** The Request Entity */
	REQUEST_ENTITY("request"),

	/** The operation */
	EMAIL_OPERATION("operation"),

	/** The requestorId */
	EMAIL_REQUESTOR_ID("requestorId"),

	/** The approverDecision */
	EMAIL_APPROVER_DECISION("approverDecision"),

	/** The fulfillmentDecision */
	EMAIL_FULFILLMENT_DECISION("fulfillmentDecision"),
	
	/** The resultDeliverDecision */
	EMAIL_RESULTS_DELIVER_DECISION("resultDeliverDecision"),

	/** The resultAcceptanceDecision */
	EMAIL_RESULT_ACCEPTANCE_DECISION("resultAcceptanceDecision"),

	/** The approverId */
	EMAIL_APPROVER_ID("approverId"),

	/** The cc_users */
	EMAIL_CC_USERS("cc"),

	/** The emailList */
	EMAIL_LIST("emailList"),

	/** The Comments */
	EMAIL_COMMENTS("Comments: "),

	/** The Your data Request */
	EMAIL_YOUR_DATE_REQUEST("Your data request "),

	/** The no reply sender */
	EMAIL_NO_REPLY_SENDER("no-reply-genisis2@DOMAIN"),
	
	NIGHTLY_JOB("NightlyJob"),
	
	TRUE("true"),
	
	FALSE("false"),

	/** Exception occurred while querying Requests on Id */
	EXCEPTION_QUERYING_REQUESTS("Exception occured while querrying Requests on Id"),
	
	/** Exception occurred while querying Request History on Request Id and Status */
	EXCEPTION_QUERRYING_REQUESTSHISTORY_REQ_ID_AND_STATUS("Exception occurred while querrying Request History on Request Id and Status"),
	
	/** Error occurred while getting User details for */
	ERROR_OCCURRED_USER_DETAILS("Error occurred while getting User details for"),
	
	/** The requester */
	REQUESTER_ROLE("requester");

	/** The text. */
	private final String text;

	/**
	 * Instantiates a new common enum.
	 *
	 * @param text
	 *            The s.
	 */
	private CommonEnum(String text) {
		this.text = text;
	}

	/**
	 * Gets the text.
	 *
	 * @return String This returns text.
	 */
	public String getText() {
		return text;
	}
}